<?php

namespace App\Observers;

use App\Models\CustomField;
use App\Models\CustomFieldGroup;
use App\Models\LeadCustomForm;
use App\Models\TicketCustomForm;

class CustomFieldsObserver
{

    public function creating(CustomField $model)
    {
        if (company()) {
            $model->company_id = company()->id;
        }
    }

    public function created(CustomField $customField)
    {
        $this->lead($customField);
        $this->ticket($customField);
    }

    private function lead($customField)
    {
        $lead = CustomFieldGroup::where('name', 'Lead')->first();

        if ($customField->custom_field_group_id == $lead->id) {
            $leadField = new LeadCustomForm();

            if ($customField->required == 'yes') {
                $leadField->required = 1;
            }
            else {
                $leadField->required = 0;
            }

            $leadField->field_display_name = $customField->label;
            $leadField->custom_fields_id = $customField->id;
            $leadField->field_name = $customField->name;
            $leadField->field_order = LeadCustomForm::max('field_order');
            $leadField->save();
        }
    }

    private function ticket($customField)
    {
        $ticket = CustomFieldGroup::where('name', 'Ticket')->first();

        if ($customField->custom_field_group_id == $ticket->id) {

            $ticketField = new TicketCustomForm();

            if ($customField->required == 'yes') {
                $ticketField->required = 1;

            }
            else {
                $ticketField->required = 0;
            }

            $ticketField->field_display_name = $customField->label;
            $ticketField->custom_fields_id = $customField->id;
            $ticketField->field_name = $customField->name;
            $ticketField->field_type = $customField->type;
            $ticketField->field_order = TicketCustomForm::max('field_order');
            $ticketField->save();
        }
    }

    public function updated(CustomField $customField)
    {
        $lead = CustomFieldGroup::where('name', 'Lead')->first();

        if ($customField->custom_field_group_id === $lead->id) {
            $id = $customField->id;
            $leadField = LeadCustomForm::firstWhere('custom_fields_id', $id);

            if ($customField->required == 'yes') {
                $leadField->required = 1;

            }
            else {
                $leadField->required = 0;
            }

            $leadField->field_display_name = $customField->label;
            $leadField->field_name = $customField->name;
            $leadField->save();
        }

        $ticket = CustomFieldGroup::where('name', 'Ticket')->first();

        if ($customField->custom_field_group_id === $ticket->id) {
            $id = $customField->id;
            $ticketField = TicketCustomForm::firstWhere('custom_fields_id', $id);

            if ($customField->required == 'yes') {
                $ticketField->required = 1;

            }
            else {
                $ticketField->required = 0;
            }

            $ticketField->field_display_name = $customField->label;
            $ticketField->custom_fields_id = $customField->id;
            $ticketField->field_name = $customField->name;
            $ticketField->field_type = $customField->type;
            $ticketField->save();
        }

    }

}

