<?php
$moveClass = '';
?>
<?php if($draggable == 'false'): ?>
    <?php
        $moveClass = 'move-disable';
    ?>
<?php endif; ?>

<div class="card rounded bg-white border-grey b-shadow-4 m-1 mb-2 <?php echo e($moveClass); ?> task-card" data-task-id="<?php echo e($lead->id); ?>"
    id="drag-task-<?php echo e($lead->id); ?>">
    <div class="card-body p-2">
        <div class="d-flex justify-content-between mb-2">
            <a href="<?php echo e(route('leads.show', [$lead->id])); ?>"
                class="f-12 f-w-500 text-dark mb-0 text-wrap openRightModal"><?php echo e(ucfirst($lead->client_name)); ?>

                <?php if(!is_null($lead->client_id)): ?>
                <i class="fa fa-check-circle text-success" data-toggle="tooltip" data-original-title="<?php echo app('translator')->get('modules.lead.convertedLead'); ?>"></i>
                <?php endif; ?>
            </a>
            <?php if(!is_null($lead->value)): ?>
                <div class="d-flex">
                    <span
                        class="ml-2 f-11 text-lightest"><?php echo e(currency_format($lead->value, $lead->currency_id)); ?></span>
                </div>
            <?php endif; ?>
        </div>

        <?php if($lead->company_name): ?>
            <div class="d-flex mb-3 align-items-center">
                <i class="fa fa-building f-11 text-lightest"></i><span
                    class="ml-2 f-11 text-lightest"><?php echo e(ucfirst($lead->company_name)); ?></span>
            </div>
        <?php endif; ?>

        <div class="d-flex justify-content-between align-items-center">
            <?php if(!is_null($lead->agent_id)): ?>
                <div class="d-flex flex-wrap">
                    <div class="avatar-img mr-1 rounded-circle">
                        <a href="<?php echo e(route('employees.show', $lead->leadAgent->user_id)); ?>" alt="<?php echo e(mb_ucwords($lead->leadAgent->user->name)); ?>" data-toggle="tooltip"
                            data-original-title="<?php echo e(__('app.leadAgent') .' : '. mb_ucwords($lead->leadAgent->user->name)); ?>"
                            data-placement="right"><img src="<?php echo e($lead->leadAgent->user->image_url); ?>"></a>
                    </div>
                </div>
            <?php endif; ?>
            <?php if($lead->next_follow_up_date != null && $lead->next_follow_up_date != ''): ?>
                <div class="d-flex text-lightest">
                    <i class="f-11 bi bi-calendar"></i><span
                        class="f-12 ml-1"><?php echo e(\Carbon\Carbon::parse($lead->next_follow_up_date)->translatedFormat(company()->date_format)); ?></span>
                </div>
            <?php endif; ?>

        </div>
    </div>
</div><!-- div end -->
<?php /**PATH /home/singinn/public_html/indiacrm.singinn.co.in/resources/views/components/cards/lead-card.blade.php ENDPATH**/ ?>