<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dfareporting;

class UvarFilter extends \Google\Collection
{
  protected $collection_key = 'values';
  /**
   * @var bool
   */
  public $complement;
  /**
   * @var string
   */
  public $index;
  /**
   * @var string
   */
  public $kind;
  /**
   * @var string
   */
  public $match;
  /**
   * @var string[]
   */
  public $values = [];

  /**
   * @param bool
   */
  public function setComplement($complement)
  {
    $this->complement = $complement;
  }
  /**
   * @return bool
   */
  public function getComplement()
  {
    return $this->complement;
  }
  /**
   * @param string
   */
  public function setIndex($index)
  {
    $this->index = $index;
  }
  /**
   * @return string
   */
  public function getIndex()
  {
    return $this->index;
  }
  /**
   * @param string
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * @param string
   */
  public function setMatch($match)
  {
    $this->match = $match;
  }
  /**
   * @return string
   */
  public function getMatch()
  {
    return $this->match;
  }
  /**
   * @param string[]
   */
  public function setValues($values)
  {
    $this->values = $values;
  }
  /**
   * @return string[]
   */
  public function getValues()
  {
    return $this->values;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(UvarFilter::class, 'Google_Service_Dfareporting_UvarFilter');
